/*
 * Decompiled with CFR 0.152.
 */
package lib.toma.animations.engine.serialization;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import lib.toma.animations.AnimationUtils;
import lib.toma.animations.EasingRegistry;
import lib.toma.animations.IEasing;
import lib.toma.animations.Keyframes;
import lib.toma.animations.api.IKeyframe;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.math.vector.Vector3d;

public class KeyframeSerializer
implements JsonSerializer<IKeyframe>,
JsonDeserializer<IKeyframe> {
    public JsonElement serialize(IKeyframe src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        float endpoint = src.endpoint();
        Vector3d pos = src.positionTarget();
        Vector3d rotation = src.rotationTarget();
        object.addProperty("e", (Number)Float.valueOf(endpoint));
        object.addProperty("ease", (Number)src.getEasing().getEasingId());
        if (!pos.equals((Object)Vector3d.field_186680_a)) {
            object.add("pos", context.serialize((Object)pos, Vector3d.class));
        }
        if (!rotation.equals((Object)Vector3d.field_186680_a)) {
            object.add("rot", context.serialize((Object)rotation, Vector3d.class));
        }
        return object;
    }

    public IKeyframe deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (!json.isJsonObject()) {
            throw new JsonSyntaxException("Not a Json object!");
        }
        JsonObject object = json.getAsJsonObject();
        float endpoint = JSONUtils.func_151217_k((JsonObject)object, (String)"e");
        EasingRegistry registry = EasingRegistry.getRegistry();
        byte easingId = JSONUtils.func_219795_a((JsonObject)object, (String)"ease", (byte)AnimationUtils.DEFAULT_EASE_FUNC.getEasingId());
        IEasing easing = registry.getEasing(easingId);
        boolean positioned = object.has("pos");
        boolean rotated = object.has("rot");
        if (!positioned && !rotated) {
            return endpoint == 0.0f ? Keyframes.none() : Keyframes.wait(endpoint, easing);
        }
        if (rotated) {
            Vector3d pos = positioned ? (Vector3d)context.deserialize(object.get("pos"), Vector3d.class) : Vector3d.field_186680_a;
            Vector3d rot = (Vector3d)context.deserialize(object.get("rot"), Vector3d.class);
            return Keyframes.keyframe(pos, rot, easing, endpoint);
        }
        Vector3d pos = (Vector3d)context.deserialize(object.get("pos"), Vector3d.class);
        return Keyframes.position(pos, easing, endpoint);
    }
}

